
import os
from datetime import datetime
import requests # type: ignore
import xml.etree.ElementTree as ET
import re, sys
import logging
import builtins
import re
import getpass




# Paso 1: Obtener el directorio actual del script
base_dir = os.path.dirname(os.path.abspath(__file__))
#base_dir = os.path.join(os.path.expandvars("%USERPROFILE%"), "Desktop")

# Paso 2: Definir rutas absolutas a Entrada, Salida, Error y Log
carpeta_entrada = os.path.join(base_dir, "Entrada")
carpeta_error = os.path.join(base_dir, "Error")
carpeta_salida = os.path.join(base_dir, "Salida")
carpeta_log = os.path.join(base_dir, "Log")


# Paso 3: Crear carpetas si no existen
for carpeta in [carpeta_entrada, carpeta_salida, carpeta_log, carpeta_error]:
    if not os.path.exists(carpeta):
        os.makedirs(carpeta)

# Paso 4:Crear ejemplo lote.txt en carpeta Entrada si no existe
contenido = '''<customer type="bean"><code>75873381</code><store>0</store><party type="bean"><firstName>Pruebas3</firstName><lastName>Inicial Cliente3</lastName><genderType>F</genderType><typeCode>PRS</typeCode><birthCountryCode>ARG</birthCountryCode><birthDayNumber>22</birthDayNumber><birthMonthNumber>09</birthMonthNumber><birthYearNumber>1980</birthYearNumber><roleAssignments type="list"><partyRoleAssignment type="bean"><partyRole id="1"><name>Cliente</name></partyRole><effectiveDate format="dd-MM-yyyy">23-08-2017</effectiveDate><expirationDate format="dd-MM-yyyy">30-12-2200</expirationDate><contactMethods type="list"><partyContactMethod type="bean"><purposeType id="2"/><methodType id="1"/><effectiveDate>2017-08-23T16:32:37.947</effectiveDate><expirationDate>2200-12-30 00:00:00.000</expirationDate><address type="bean"> <city type="bean"><code>7346</code></city><country type="bean"> <code>PER</code></country><state type="bean"><code>7</code></state><firstLine>AVDA SAN MARTIN 486</firstLine><postalCode>3206</postalCode></address><emailAddress type="bean"><name>alejandro.silva@napse.global</name></emailAddress><telephone type="bean"><areaCode>11</areaCode><telephoneNumber>23878069</telephoneNumber><countryCode>54</countryCode></telephone></partyContactMethod></contactMethods><sequenceNumber>1</sequenceNumber></partyRoleAssignment></roleAssignments><identifications type="list"><partyIdentification type="bean"><identificationType id="1"/><identifierValue>75873380</identifierValue></partyIdentification></identifications></party>'''

ruta_archivo = os.path.join(carpeta_entrada, "lote.txt")

with open(ruta_archivo, "w", encoding="utf-8") as archivo:
    archivo.write(contenido)

# Generar nombre de archivo basado en la fecha
fecha_hoy = datetime.now().strftime("%Y-%m-%d")
nombre_log = f"log_{fecha_hoy}.txt"
ruta_log = os.path.join(carpeta_log, nombre_log)

# Configurar logging para agregar al archivo del día
logging.basicConfig(
    filename=ruta_log,
    filemode="a",  # append (agregar, no borrar)
    level=logging.INFO,
    format="%(asctime)s - %(levelname)s - %(message)s",
    encoding="utf-8"
)

# Guardar print original
print_original = builtins.print

# Redefinir print para que también lo escriba al log
def print(*args, **kwargs):
    mensaje = ' '.join(str(arg) for arg in args)
    logging.info(mensaje)
    print_original(*args, **kwargs)

# Definimos el titulo inicial del script
def mostrar_banner():
    texto = "NAPSE BRIDGE"
    ancho_total = 100
    relleno = (ancho_total - len(texto) - 2) // 2  # -2 por los bordes

    print("=" * ancho_total)
    print("|" + " " * (ancho_total - 2) + "|")
    print("|" + " " * relleno + texto + " " * (ancho_total - len(texto) - relleno - 2) + "|")
    print("|" + " " * (ancho_total - 2) + "|")
    print("=" * ancho_total)

# Definimos el titulo primera parte del script
def mostrar_banner2():
    texto = "Primera Parte - Armado Json"
    ancho_total = 60
    relleno = (ancho_total - len(texto) - 2) // 2  # -2 por los bordes

    print("=" * ancho_total)
    print("|" + " " * (ancho_total - 2) + "|")
    print("|" + " " * relleno + texto + " " * (ancho_total - len(texto) - relleno - 2) + "|")
    print("|" + " " * (ancho_total - 2) + "|")
    print("=" * ancho_total)

# Definimos el titulo segunda parte del script
def mostrar_banner3():
    texto = "Segunda Parte - Envio json servicio"
    ancho_total = 60
    relleno = (ancho_total - len(texto) - 2) // 2  # -2 por los bordes

    print("=" * ancho_total)
    print("|" + " " * (ancho_total - 2) + "|")
    print("|" + " " * relleno + texto + " " * (ancho_total - len(texto) - relleno - 2) + "|")
    print("|" + " " * (ancho_total - 2) + "|")
    print("=" * ancho_total)

# Parte 5: estructura inicial 
mostrar_banner()
print(" ")
print("Creado por Alejandro Silva - Ver. 6.0") 
print(" ")
nombre_operador = getpass.getuser() # <-- toma el nombre de la maquina para saber quien ejecuto
print(f"Bienvenido, {nombre_operador}.")
print(" ")
mostrar_banner2()
print("Documentacion Envio por servico: https://share.linx.com.br/pages/viewpage.action?pageId=333090391 ")
print(" ")
print("En la carpeta Entrada debemos colocar el archivo denominado lote.txt. (Se ha creado un archivo de ejemplo para Customer).")
print("el cual contiene los registros que se desean enviar a través del servicio.")
print("De esta forma, este programa generará el JSON para enviar. ")
print(" ")


# Paso 6: Validacion que las carpetas existan
for carpeta in [carpeta_entrada, carpeta_salida,carpeta_log, carpeta_error]:
    if not os.path.isdir(carpeta):
        os.makedirs(carpeta)
        print(f"✅ Carpeta creada: {carpeta}")
    else:
        print(f"✔️ Carpeta existente: {carpeta}")

# Paso 5: Ruta completa del archivo de entrada
archivo_entrada = os.path.join(carpeta_entrada, "lote.txt")

# Verificar que el archivo exista
if not os.path.isfile(archivo_entrada):
    print(f"❌ No se encontró el archivo: {archivo_entrada}")
    exit(1)

# Paso 6: Leer el archivo
with open(archivo_entrada, 'r', encoding='utf-8') as f:
    contenido = f.read()

print("✅ Archivo leído correctamente.")

 

fecha_actual = datetime.now().strftime('%Y%m%d')  # Formato: YYYYMMDD

def dividir_archivo(archivo_entrada, registros_por_archivo=100, texto1='', texto2='', entidad='entidad', fecha='YYYYMMDD'):
    try:
        # Obtener el directorio donde está ubicado el archivo de salida
        directorio_salida = carpeta_salida

        contador_archivo = 1
        registros = []

        with open(archivo_entrada, 'r', encoding='utf-8') as archivo:
            for linea in archivo:
                registros.append(linea)

                if len(registros) == registros_por_archivo:
                    nombre_archivo_salida = os.path.join(directorio_salida, f'{entidad}_lote_{fecha}_pte_{contador_archivo}.xml')
                    try:
                        with open(nombre_archivo_salida, 'w', encoding='utf-8') as salida:
                            salida.write(texto1 + '\n')
                            salida.writelines(registros)
                            salida.write('\n' + texto2)

                        logging.info(f'Archivo creado: {nombre_archivo_salida} con {len(registros)} registros.')
                        print(f'Archivo {nombre_archivo_salida} creado con {len(registros)} registros.')
                    except Exception as e:
                        logging.error(f'Error al escribir archivo {nombre_archivo_salida}: {e}')

                    registros = []
                    contador_archivo += 1

        # Si quedan registros al final, guardarlos también
        if registros:
            nombre_archivo_salida = os.path.join(directorio_salida, f'{entidad}_lote_{fecha}_pte_{contador_archivo}.xml')
            try:
                with open(nombre_archivo_salida, 'w', encoding='utf-8') as salida:
                    salida.write(texto1 + '\n')
                    salida.writelines(registros)
                    salida.write('\n' + texto2)

                logging.info(f'Archivo creado: {nombre_archivo_salida} con {len(registros)} registros (finales).')
            except Exception as e:
                logging.error(f'Error al escribir archivo final {nombre_archivo_salida}: {e}')

    except FileNotFoundError:
        logging.error(f'El archivo de entrada no existe: {archivo_entrada}')
    except Exception as e:
        logging.error(f'Ocurrió un error inesperado en dividir_archivo: {e}')



# Función principal para preguntar y decidir qué texto usar
print("Comenzamos? ")
print(" ")
def main():
    opciones = [
        "1 - Items",
        "2 - Clientes",
        "3 - Proveedor",
        "4 - Marca",
        "5 - Jerarquía (Level)",
        "7 - Unidad de Medida",
        "8 - Deposito",
        "9 - Atributo del Item",
        "10 - Codigo de Barra",
        "11 - Artículos de tipo Stock",
        "12 - Kits/enlazados",
        "13 - Artículos relacionados",
        "14 - Relación de artículos con proveedores",
        "15 - Lista de Precios",
        "16 - Importación impuestos internos por artículos",
        "17 - Stock"
    ]

    opciones_validas = {str(i) for i in range(1, 18)}  # {"1", "2", ..., "17"}
        
    while True:
        print("¿A qué servicio querés enviar?\n")

        columnas = 3
        filas = (len(opciones) + columnas - 1) // columnas  # Redondeo hacia arriba

        for i in range(filas):
            fila = ""
            for j in range(columnas):
                index = i + j * filas
                if index < len(opciones):
                    fila += opciones[index].ljust(45)  # Ajusta el espaciado a gusto
            print(fila)

        tipo_envio = input("\nSeleccioná una opción: ").strip().lower()

        #log escribe
        logging.info(f"Opción seleccionada: {tipo_envio}")
        if tipo_envio in opciones_validas:
            break
        else:
            print("\n❌ Opción no válida. Por favor, seleccioná una opción del 1 al 17.\n")
            logging.info("Tipo de envío no válido")

    if tipo_envio == "2":
        entidad = "cliente"
        texto1 = '''<soapenv:Envelope xmlns:soapenv="http://schemas.xmlsoap.org/soap/envelope/" xmlns:ser="http://services.business.soap.bridge.synthesis.com/">
   <soapenv:Header/>
   <soapenv:Body>
      <ser:execute>
         <!--Optional:-->
         <service>customer</service>
         <!--Optional:-->
         <request><![CDATA[ <bridgeCoreRequest> <operation>CreateOrUpdate</operation> <params> <customers type='list'>'''

        texto2 = '''</customer> </customers> </params> </bridgeCoreRequest> ]]></request>
         <!--Optional:-->
         <store>100000003</store>
      </ser:execute>
   </soapenv:Body>
</soapenv:Envelope>'''
    elif tipo_envio == "1":
        entidad = "Item"
        texto1 = '''<soapenv:Envelope xmlns:soapenv="http://schemas.xmlsoap.org/soap/envelope/" xmlns:ser="http://services.business.soap.bridge.synthesis.com/">
    <soapenv:Header/>
    <soapenv:Body>
    <ser:execute>
    <!--Optional:-->
    <service>item</service>
    <request>
    <![CDATA[
    <bridgeCoreRequest>
    <operation>createOrUpdate</operation>
    <params>
    <items type='list'>'''
        texto2 = '''</item>
        </items>
    </params>
    <replicationStore>0</replicationStore>
    </bridgeCoreRequest>
    ]]>
    </request>
    <!--Optional:-->
    <store>0</store>
    </ser:execute>
    </soapenv:Body>
    </soapenv:Envelope>'''
    elif tipo_envio == "3":
        entidad = "Proveedor"
        texto1 = '''
<soapenv:Envelope xmlns:soapenv="http://schemas.xmlsoap.org/soap/envelope/" xmlns:ser="http://services.business.soap.bridge.synthesis.com/">
    <soapenv:Header/>
    <soapenv:Body>
    <ser:execute>
    <!--Optional:-->
    <service>supplier</service>
    <request>
    <![CDATA[
    <bridgeCoreRequest>
    <operation>createOrUpdate</operation>
    <params>
    <suppliers type="list">
    '''
        texto2 = ''' </supplier>
    </suppliers>
     </params>
    <replicationStore>0</replicationStore>
    </bridgeCoreRequest>
    ]]>
    </request>
    <!--Optional:-->
    <store>0</store>
    </ser:execute>
    </soapenv:Body>
    </soapenv:Envelope>'''
    elif tipo_envio == "4":
        entidad = "Marca"
        texto1 = '''
<soapenv:Envelope xmlns:soapenv="http://schemas.xmlsoap.org/soap/envelope/" xmlns:ser="http://services.business.soap.bridge.synthesis.com/">
    <soapenv:Header/>
    <soapenv:Body>
    <ser:execute>
    <!--Optional:-->
    <service>brand</service>
    <request>
    <![CDATA[
    <bridgeCoreRequest>
    <operation>createOrUpdate</operation>
    <params>
    <brands type="list">
    '''
        texto2 = ''' </supplier>
    </brands>
     </params>
    <replicationStore>0</replicationStore>
    </bridgeCoreRequest>
    ]]>
    </request>
    <!--Optional:-->
    <store>0</store>
    </ser:execute>
    </soapenv:Body>
    </soapenv:Envelope>'''
    elif tipo_envio == "5":
        entidad = "Jerarquia(Level)"
        texto1 = '''
<soapenv:Envelope xmlns:soapenv="http://schemas.xmlsoap.org/soap/envelope/" xmlns:ser="http://services.business.soap.bridge.synthesis.com/">
    <soapenv:Header/>
    <soapenv:Body>
    <ser:execute>
    <!--Optional:-->
    <service>merchandiseHierarchy</service>
    <request>
    <![CDATA[
    <bridgeCoreRequest>
    <operation>createOrUpdate</operation>
    <params>
    <merchHierarchyLevels type="list">
    '''
        texto2 = ''' </hierarchyLevel>
    </merchHierarchyLevels>
     </params>
    <replicationStore>0</replicationStore>
    </bridgeCoreRequest>
    ]]>
    </request>
    <!--Optional:-->
    <store>0</store>
    </ser:execute>
    </soapenv:Body>
    </soapenv:Envelope>'''
    elif tipo_envio == "6":
        entidad = "Jerarquia(Group)"
        texto1 = '''
<soapenv:Envelope xmlns:soapenv="http://schemas.xmlsoap.org/soap/envelope/" xmlns:ser="http://services.business.soap.bridge.synthesis.com/">
    <soapenv:Header/>
    <soapenv:Body>
    <ser:execute>
    <!--Optional:-->
    <service>merchandiseHierarchy</service>
    <request>
    <![CDATA[
    <bridgeCoreRequest>
    <operation>createOrUpdate</operation>
    <params>
    <merchHierarchyGroups type="list">
    '''
        texto2 = ''' </hierarchyGroup>
    </merchHierarchyGroups>
     </params>
    <replicationStore>0</replicationStore>
    </bridgeCoreRequest>
    ]]>
    </request>
    <!--Optional:-->
    <store>0</store>
    </ser:execute>
    </soapenv:Body>
    </soapenv:Envelope>'''
    elif tipo_envio == "7":
        entidad = "Unidad de Medida"
        texto1 = '''
<soapenv:Envelope xmlns:soapenv="http://schemas.xmlsoap.org/soap/envelope/" xmlns:ser="http://services.business.soap.bridge.synthesis.com/">
    <soapenv:Header/>
    <soapenv:Body>
    <ser:execute>
    <!--Optional:-->
    <service>unitOfMeasure</service>
    <request>
    <![CDATA[
    <bridgeCoreRequest>
    <operation>createOrUpdate</operation>
    <params>
    <uoms type="list">
    '''
        texto2 = ''' </uom>
    </uoms>
     </params>
    <replicationStore>0</replicationStore>
    </bridgeCoreRequest>
    ]]>
    </request>
    <!--Optional:-->
    <store>0</store>
    </ser:execute>
    </soapenv:Body>
    </soapenv:Envelope>'''
    elif tipo_envio == "8":
        entidad = "Deposito"
        texto1 = '''
    <soapenv:Envelope xmlns:soapenv="http://schemas.xmlsoap.org/soap/envelope/" xmlns:ser="http://services.business.soap.bridge.synthesis.com/">
    <soapenv:Header/>
    <soapenv:Body>
    <ser:execute>
    <!--Optional:-->
    <service>location</service>
    <request>
    <![CDATA[
    <bridgeCoreRequest>
    <operation>createOrUpdate</operation>
    <params>
    <locations type="list">
    '''
        texto2 = ''' </location>
    </locations>
     </params>
    <replicationStore>0</replicationStore>
    </bridgeCoreRequest>
    ]]>
    </request>
    <!--Optional:-->
    <store>0</store>
    </ser:execute>
    </soapenv:Body>
    </soapenv:Envelope>'''
    elif tipo_envio == "9":
        entidad = "Atributo de Item"
        texto1 = '''
    <soapenv:Envelope xmlns:soapenv="http://schemas.xmlsoap.org/soap/envelope/" xmlns:ser="http://services.business.soap.bridge.synthesis.com/">
    <soapenv:Header/>
    <soapenv:Body>
    <ser:execute>
    <!--Optional:-->
    <service>itemAttribute</service>
    <request>
    <![CDATA[
    <bridgeCoreRequest>
    <operation>createOrUpdate</operation>
    <params>
    <itemAttributes type="list">
    '''
        texto2 = ''' </itemAttribute>
    </itemAttributes>
     </params>
    <replicationStore>0</replicationStore>
    </bridgeCoreRequest>
    ]]>
    </request>
    <!--Optional:-->
    <store>0</store>
    </ser:execute>
    </soapenv:Body>
    </soapenv:Envelope>'''
    elif tipo_envio == "10":
        entidad = "Codigo de Barra"
        texto1 = '''
    <soapenv:Envelope xmlns:soapenv="http://schemas.xmlsoap.org/soap/envelope/" xmlns:ser="http://services.business.soap.bridge.synthesis.com/">
    <soapenv:Header/>
    <soapenv:Body>
    <ser:execute>
    <!--Optional:-->
    <service>alias</service>
    <request>
    <![CDATA[
    <bridgeCoreRequest>
    <operation>createOrUpdate</operation>
    <params>
    <aliases type="list">
    '''
        texto2 = ''' </alias>
    </aliases>
     </params>
    <replicationStore>0</replicationStore>
    </bridgeCoreRequest>
    ]]>
    </request>
    <!--Optional:-->
    <store>0</store>
    </ser:execute>
    </soapenv:Body>
    </soapenv:Envelope>'''
    elif tipo_envio == "11":
        entidad = "Articulo de tipo Stock"
        texto1 = '''
    <soapenv:Envelope xmlns:soapenv="http://schemas.xmlsoap.org/soap/envelope/" xmlns:ser="http://services.business.soap.bridge.synthesis.com/">
    <soapenv:Header/>
    <soapenv:Body>
    <ser:execute>
    <!--Optional:-->
    <service>stockItems</service>
    <request>
    <![CDATA[
    <bridgeCoreRequest>
    <operation>createOrUpdate</operation>
    <params>
    <stockItems type="list">
    '''
        texto2 = ''' </stockItem>
    </stockItems>
     </params>
    <replicationStore>0</replicationStore>
    </bridgeCoreRequest>
    ]]>
    </request>
    <!--Optional:-->
    <store>0</store>
    </ser:execute>
    </soapenv:Body>
    </soapenv:Envelope>'''
    elif tipo_envio == "12":
        entidad = "Kits Enlazados"
        texto1 = '''
    <soapenv:Envelope xmlns:soapenv="http://schemas.xmlsoap.org/soap/envelope/" xmlns:ser="http://services.business.soap.bridge.synthesis.com/">
    <soapenv:Header/>
    <soapenv:Body>
    <ser:execute>
    <!--Optional:-->
    <service>linkedItem</service>
    <request>
    <![CDATA[
    <bridgeCoreRequest>
    <operation>createOrUpdate</operation>
    <params>
    <linkedItem type="list">
    '''
        texto2 = ''' </item>
    </linkedItem>
     </params>
    <replicationStore>0</replicationStore>
    </bridgeCoreRequest>
    ]]>
    </request>
    <!--Optional:-->
    <store>0</store>
    </ser:execute>
    </soapenv:Body>
    </soapenv:Envelope>'''
    elif tipo_envio == "13":
        entidad = "Articulos relacionados"
        texto1 = '''
    <soapenv:Envelope xmlns:soapenv="http://schemas.xmlsoap.org/soap/envelope/" xmlns:ser="http://services.business.soap.bridge.synthesis.com/">
    <soapenv:Header/>
    <soapenv:Body>
    <ser:execute>
    <!--Optional:-->
    <service>itemRelated</service>
    <request>
    <![CDATA[
    <bridgeCoreRequest>
    <operation>createOrUpdate</operation>
    <params>
    <itemsRelated type="list">
    '''
        texto2 = ''' </itemRelated>
    </itemsRelated>
     </params>
    <replicationStore>0</replicationStore>
    </bridgeCoreRequest>
    ]]>
    </request>
    <!--Optional:-->
    <store>0</store>
    </ser:execute>
    </soapenv:Body>
    </soapenv:Envelope>'''
    elif tipo_envio == "14":
        entidad = "Relacion articulos con Proveedores"
        texto1 = '''
    <soapenv:Envelope xmlns:soapenv="http://schemas.xmlsoap.org/soap/envelope/" xmlns:ser="http://services.business.soap.bridge.synthesis.com/">
    <soapenv:Header/>
    <soapenv:Body>
    <ser:execute>
    <!--Optional:-->
    <service>itemSupplierItem</service>
    <request>
    <![CDATA[
    <bridgeCoreRequest>
    <operation>createOrUpdate</operation>
    <params>
    <itemSupplierItems type="list">
    '''
        texto2 = ''' </itemSupplierItem>
    </itemSupplierItems>
     </params>
    <replicationStore>0</replicationStore>
    </bridgeCoreRequest>
    ]]>
    </request>
    <!--Optional:-->
    <store>0</store>
    </ser:execute>
    </soapenv:Body>
    </soapenv:Envelope>'''   
    elif tipo_envio == "15":
        entidad = "Lista de Precios"
        texto1 = '''
    <soapenv:Envelope xmlns:soapenv="http://schemas.xmlsoap.org/soap/envelope/" xmlns:ser="http://services.business.soap.bridge.synthesis.com/">
    <soapenv:Header/>
    <soapenv:Body>
    <ser:execute>
    <!--Optional:-->
    <service>itemSellingPrices</service>
    <request>
    <![CDATA[
    <bridgeCoreRequest>
    <operation>createOrUpdate</operation>
    <params>
    <itemSellingPrices type="list">
    '''
        texto2 = ''' </itemSupplierItem>
    </itemSellingPrices>
     </params>
    <replicationStore>0</replicationStore>
    </bridgeCoreRequest>
    ]]>
    </request>
    <!--Optional:-->
    <store>0</store>
    </ser:execute>
    </soapenv:Body>
    </soapenv:Envelope>'''   
    elif tipo_envio == "16":
        entidad = "Importacion impuestos internos por articulo"
        texto1 = '''
    <soapenv:Envelope xmlns:soapenv="http://schemas.xmlsoap.org/soap/envelope/" xmlns:ser="http://services.business.soap.bridge.synthesis.com/">
    <soapenv:Header/>
    <soapenv:Body>
    <ser:execute>
    <!--Optional:-->
    <service>itemInternalTax</service>
    <request>
    <![CDATA[
    <bridgeCoreRequest>
    <operation>createOrUpdate</operation>
    <params>
    <itemInternalTaxes type="list">
    '''
        texto2 = ''' </itemInternalTax>
    </itemInternalTaxes>
     </params>
    <replicationStore>0</replicationStore>
    </bridgeCoreRequest>
    ]]>
    </request>
    <!--Optional:-->
    <store>0</store>
    </ser:execute>
    </soapenv:Body>
    </soapenv:Envelope>'''          
    elif tipo_envio == "17":
        entidad = "Stock"
        texto1 = '''
    <soapenv:Envelope xmlns:soapenv="http://schemas.xmlsoap.org/soap/envelope/" xmlns:ser="http://services.business.soap.bridge.synthesis.com/">
    <soapenv:Header/>
    <soapenv:Body>
    <ser:execute>
    <!--Optional:-->
    <service>stock</service>
    <request>
    <![CDATA[
    <bridgeCoreRequest>
    <operation>createOrUpdate</operation>
    <params>
    <stocks type="list">
    '''
        texto2 = ''' </stock>
    </stocks>
     </params>
    <replicationStore>0</replicationStore>
    </bridgeCoreRequest>
    ]]>
    </request>
    <!--Optional:-->
    <store>0</store>
    </ser:execute>
    </soapenv:Body>
    </soapenv:Envelope>'''          


    else:
        print("Tipo de envío no válido.")
        #log
        logging.info("Tipo de envío no válido")
        
        return

    # Pedir al usuario la cantidad de registros por archivo
    try:
        entrada = input("Ingrese la cantidad de registros por archivo (predeterminado 1000): ").strip()
        registros_por_archivo = int(entrada)
        logging.info(f"Cantidad seleccionada {entrada}")

        if registros_por_archivo <= 0:
            print("Cantidad inválida. Se usará la cantidad de 1000 registros por archivo.")
            registros_por_archivo = 1000
            logging.info("Cantidad inválida. Se usa el valor por defecto: 1000 registros por archivo.")
        else:
            logging.info(f"Opción seleccionada: {registros_por_archivo}")

    except ValueError:
        print("Entrada no válida. Se usará predeterminado de 1000 registros por archivo.")
        registros_por_archivo = 1000
        logging.info("Entrada no válida. Se usa el valor por defecto: 1000 registros.")

    except Exception:
        logging.error("Error inesperado al solicitar cantidad de registros.", exc_info=True)
        registros_por_archivo = 1000  # Aseguramos que tenga un valor para continuar

        
    archivo_entrada = os.path.join(carpeta_entrada, "lote.txt")
    dividir_archivo(archivo_entrada, registros_por_archivo, texto1, texto2,entidad,fecha_actual)

# Ejecutar el script principal
if __name__ == "__main__":
    main()

# Segunda seccion donde se enviar el archivo al BMC
print(" ")
mostrar_banner3()
#print("Segunda Parte")
#print("Programa que envia por a servicio al BMC")
print(" ")
print("Enviaremos los archivo json creado en el paso anterior al BMC") 
print("Debemos colocar la URL del BMC con su respectivo API") 
print(" ") 
 
# Configura la carpeta donde están los archivos de solicitud
request_folder = carpeta_salida
request_folder2 = carpeta_error

# URL del servicio SOAP
#url PRD = "https://bmc-diffupar.napse.global:8445/bridge/services/bridgeCoreSOAP"
#Url QA = "https://10.4.145.50:8445/bridge/services/bridgeCoreSOAP"
# ip url prd : 48.217.198.184
#url Diffu = "https://10.4.145.50:8445/bridge/services/bridgeCoreSOAP"
#url FOCO  = "https://10.4.148.51:8444/bridge/services/bridgeCoreSOAP"
 

# Expresión regular para validar la URL
# Regex: http o https, host o IP, puerto obligatorio, NO ruta después del puerto
URL_REGEX = re.compile(
    r'^https?://'                             # protocolo http o https
    r'([a-zA-Z0-9.-]+|\d{1,3}(\.\d{1,3}){3})'  # host o IP
    r':\d+'                                  # puerto obligatorio
    r'$'                                     # FIN de la cadena, no ruta ni slash extra
)

def pedir_url():
    while True:
        url = input("Ingrese la URL BMC/API (ej: https://10.4.148.51:8444): ").strip()
        if URL_REGEX.match(url):
            logging.info(f'URL válida ingresada: {url}')
            return url
        else:
            print("❌ URL inválida. La URL debe tener este formato EXACTO: http(s)://host:puerto")
            print("Por favor, ingrese nuevamente la URL.\n")
            logging.error(f'URL inválida ingresada: {url}')

# Uso
base_url = pedir_url()
print("✅ URL válida:", base_url)
 
#log
logging.info(f"Opción seleccionada: {base_url}")

# Parte fija que se agrega automáticamente
path = "/bridge/services/bridgeCoreSOAP"

# Armado final de la URL
url = base_url + path

print("URL completa:", url)

# Ruta del archivo de errores
# Asegurar que la carpeta existe
os.makedirs(request_folder2, exist_ok=True)

# Ruta del archivo de errores
 
error_file_path = os.path.join(request_folder2, f'Error_log_{fecha_actual}.txt')

# Generar nombre de archivo basado en la fecha
fecha_hoy = datetime.now().strftime("%Y-%m-%d")
##nombre_log_error = f"Error_log_2_{fecha_hoy}.txt"
ruta_log_error = os.path.join(request_folder2, error_file_path)

# Configurar logging error para agregar al archivo del día
logging.basicConfig(
    filename=ruta_log_error,
    filemode="a",  # append (agregar, no borrar)
    level=logging.INFO,
    format="%(asctime)s - %(message)s",
    encoding="utf-8"
)

# Guardar print original
print_original = builtins.print

# Redefinir print para que también lo escriba al log
def print(*args, **kwargs):
    mensaje = ' '.join(str(arg) for arg in args)
    logging.info(mensaje)
    print_original(*args, **kwargs)



def process_request(file_path):
    with open(file_path, "r", encoding="utf-8") as file:
        soap_request = file.read()

    headers = {
        'Content-Type': 'text/xml; charset=utf-8',
        'SOAPAction': ''
    }

    try:
        response = requests.post(url, data=soap_request, headers=headers, verify=False)

        if response.status_code == 200:
            logging.info(f"Request SOAP: {response.status_code}")
            root = ET.fromstring(response.text)
            ack = root.find('.//ack')
            logging.info(f"ack: {ack}")
            logging.info(f"Root: {root}")

            if ack is not None:
                ack_value = ack.text

                if ack_value != "0":  # corregido con comillas
                    logging.info(f"ack {ack_value}")
                    code = ET.fromstring(soap_request).find('.//code')
                    code_value = code.text if code is not None else "No se encontró código."
                    logging.info(f"Code Value {code_value}")

                    error_message = (
                            f"{datetime.now().strftime('%Y-%m-%d %H:%M:%S')} - "
                                f"Archivo: {file_path}, Código: {code_value}, ack: {ack_value}, Respuesta: {response.text}\n"
                                f"Línea del cliente: {soap_request.strip()}\n"
                            )
                    with open(error_file_path, "a", encoding="utf-8") as error_file:
                        error_file.write(error_message)
                    print(f"Error registrado para {file_path}")
                    logging.info(error_message)
        else:
            print(f"Error {response.status_code} para {file_path}: {response.text}")

    except Exception as e:
     
        timestamp = datetime.now().strftime('%Y-%m-%d %H:%M:%S')
        error_line = f"{timestamp} - Error al procesar {file_path}: {e}\n"

        print(error_line.strip())

        with open(error_file_path, "a", encoding="utf-8") as error_file:
            error_file.write(error_line)

        logging.error(error_line.strip())

def job():
    # Listar archivos en la carpeta que sigan el patrón "lote_"
    files = [f for f in os.listdir(request_folder) if 'lote' in f and f.endswith('.xml') and re.search(r'\d+', f)]

    if not files:
        print("No hay archivos 'lote_' en la carpeta. Terminado.")
        logging.info("No se encontraron archivos 'lote_n' para procesar en la carpeta.")
        return

    for file in files:
        file_path = os.path.join(request_folder, file)
        try:
            process_request(file_path)
            os.remove(file_path)
            print(f"Archivo procesado y eliminado: {file}")
            logging.info(f"Archivo procesado y eliminado: {file}")
        except Exception as e:
            print(f"❌ Error al procesar o eliminar el archivo {file}: {e}")
            logging.error(f"Error al procesar o eliminar el archivo {file}: {e}")

    print("Todos los archivos han sido procesados. Terminando el script.")
    print(f"Muchas Gracias {nombre_operador} por utilizar este programa.")
    logging.info(f"Script finalizado por el operador: {nombre_operador}")
    
# Ejecutar la función de trabajo una sola vez
job()

#creado por Alejandro Silva - Analista Funcional